﻿//////////////////////////////////////////////
// ResourceSetLoadResult.h
//
//////////////////////////////////////////////

/// Defines / macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class BlendState ;
	class Buffer ;
	class Camera ;
	class Compositor ;
	class DepthStencilState ;
	class Mesh ;
	class Node ;
	class Program ;
	class RasterState ;
	class RenderQueue ;
	class Sampler ;
	class Shader ;
	class Texture ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

// nkMemory
#include <NilkinsMemory/Containers/BufferCast.h>
	
/// Classe -----------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT ResourceSetLoadResult final
	{			
		public :
		
			// Constructor
			ResourceSetLoadResult () noexcept ;

			// Getters / Setters
			nkMemory::BufferCast<Mesh*>& getMeshes () ;
			nkMemory::BufferCast<Shader*>& getShaders () ;
			nkMemory::BufferCast<Program*>& getPrograms () ;
			nkMemory::BufferCast<Sampler*>& getSamplers () ;
			nkMemory::BufferCast<Texture*>& getTextures () ;
			nkMemory::BufferCast<Node*>& getScenes () ;
			nkMemory::BufferCast<Compositor*>& getCompositors () ;
			nkMemory::BufferCast<Buffer*>& getBuffers () ;
			nkMemory::BufferCast<BlendState*>& getBlendStates () ;
			nkMemory::BufferCast<DepthStencilState*>& getDepthStencilStates () ;
			nkMemory::BufferCast<RasterState*>& getRasterStates () ;
			nkMemory::BufferCast<Camera*>& getCameras () ;
			nkMemory::BufferCast<RenderQueue*>& getRenderQueues () ;
			Compositor* getDefaultCompositor () const ;

			void setDefaultCompositor (Compositor* value) ;

			// Utils
			void clear () ;

		private :
		
			// Attributs
			// Les modèles
			nkMemory::BufferCast<Mesh*> _meshes ;
			// Les shaders
			nkMemory::BufferCast<Shader*> _shaders ;
			// Les shader programs
			nkMemory::BufferCast<Program*> _programs ;
			// Les samplers chargés
			nkMemory::BufferCast<Sampler*> _samplers ;
			// Les textures
			nkMemory::BufferCast<Texture*> _textures ;
			// Les scènes
			nkMemory::BufferCast<Node*> _scenes ;
			// Les compositors
			nkMemory::BufferCast<Compositor*> _compositors ;
			// Les compute buffers
			nkMemory::BufferCast<Buffer*> _computeBuffers ;
			// States
			nkMemory::BufferCast<BlendState*> _blendStates ;
			nkMemory::BufferCast<DepthStencilState*> _depthStencilStates ;
			nkMemory::BufferCast<RasterState*> _rasterStates ;
			// Caméras
			nkMemory::BufferCast<Camera*> _cameras ;
			// RQ
			nkMemory::BufferCast<RenderQueue*> _renderQueues ;

			// Compositor actif
			Compositor* _defaultCompositor ;
	} ;
}